<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Suppliers extends CI_Controller
{
    /**
     * Index Page for this controller.
     *
     * Maps to the following URL
     * 		http://example.com/index.php/welcome
     *	- or -
     * 		http://example.com/index.php/welcome/index
     *	- or -
     * Since this controller is set as the default controller in
     * config/routes.php, it's displayed at http://example.com/
     *
     * So any other public methods not prefixed with an underscore will
     * map to /index.php/welcome/<method_name>
     *
     * @see http://codeigniter.com/user_guide/general/urls.html
     */
    public function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        $this->load->library('session');
        $this->load->model('Suppliers_model');
        $this->load->model('Constant_model');
        $this->load->library('form_validation');
        $this->load->helper('form');
        $this->load->helper('url');
        $this->load->library('pagination');

        $settingResult = $this->db->get_where('site_setting');
        $settingData = $settingResult->row();

        $setting_timezone = $settingData->timezone;

        date_default_timezone_set("$setting_timezone");
    }

    public function index()
    {
        $this->load->view('dashboard', 'refresh');
    }

    // ****************************** View Page -- START ****************************** //

    // View Suppliers;
    public function suppliers()
    {
        $paginationData = $this->Constant_model->getDataOneColumn('site_setting', 'id', '1');
        $pagination_limit = $paginationData[0]->pagination;

        $config = array();
        $config['base_url'] = base_url().'suppliers/suppliers/';

        $config['display_pages'] = true;
        $config['first_link'] = 'First';

        $config['total_rows'] = $this->Suppliers_model->record_suppliers_count();
        $config['per_page'] = $pagination_limit;
        $config['uri_segment'] = 3;

        $config['full_tag_open'] = "<ul class='pagination pagination-right margin-none'>";
        $config['full_tag_close'] = '</ul>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = '<li>';
        $config['next_tagl_close'] = '</li>';
        $config['prev_tag_open'] = '<li>';
        $config['prev_tagl_close'] = '</li>';
        $config['first_tag_open'] = '<li>';
        $config['first_tagl_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tagl_close'] = '</li>';

        $this->pagination->initialize($config);

        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        $data['results'] = $this->Suppliers_model->fetch_suppliers_data($config['per_page'], $page);

        $data['links'] = $this->pagination->create_links();

        if ($page == 0) {
            $have_count = $this->Suppliers_model->record_suppliers_count();
            $sh_text = 'Showing 1 to '.count($data['results']).' of '.$this->Suppliers_model->record_suppliers_count().' entries';
        } else {
            $start_sh = $page + 1;
            $end_sh = $page + count($data['results']);
            $sh_text = "Showing $start_sh to $end_sh of ".$this->Suppliers_model->record_suppliers_count().' entries';
        }

        $data['displayshowingentries'] = $sh_text;

        $data['lang_dashboard'] = $this->lang->line('dashboard');
        $data['lang_customers'] = $this->lang->line('customers');
        $data['lang_gift_card'] = $this->lang->line('gift_card');
        $data['lang_add_gift_card'] = $this->lang->line('add_gift_card');
        $data['lang_list_gift_card'] = $this->lang->line('list_gift_card');
        $data['lang_debit'] = $this->lang->line('debit');
        $data['lang_sales'] = $this->lang->line('sales');
        $data['lang_today_sales'] = $this->lang->line('today_sales');
        $data['lang_opened_bill'] = $this->lang->line('opened_bill');
        $data['lang_reports'] = $this->lang->line('reports');
        $data['lang_sales_report'] = $this->lang->line('sales_report');
        $data['lang_expenses'] = $this->lang->line('expenses');
        $data['lang_expenses_category'] = $this->lang->line('expenses_category');
        $data['lang_pnl'] = $this->lang->line('pnl');
        $data['lang_pnl_report'] = $this->lang->line('pnl_report');
        $data['lang_pos'] = $this->lang->line('pos');
        $data['lang_return_order'] = $this->lang->line('return_order');
        $data['lang_return_order_report'] = $this->lang->line('return_order_report');
        $data['lang_inventory'] = $this->lang->line('inventory');
        $data['lang_products'] = $this->lang->line('products');
        $data['lang_list_products'] = $this->lang->line('list_products');
        $data['lang_print_product_label'] = $this->lang->line('print_product_label');
        $data['lang_product_category'] = $this->lang->line('product_category');
        $data['lang_purchase_order'] = $this->lang->line('purchase_order');
        $data['lang_setting'] = $this->lang->line('setting');
        $data['lang_outlets'] = $this->lang->line('outlets');
        $data['lang_users'] = $this->lang->line('users');
        $data['lang_suppliers'] = $this->lang->line('suppliers');
        $data['lang_system_setting'] = $this->lang->line('system_setting');
        $data['lang_payment_methods'] = $this->lang->line('payment_methods');
        $data['lang_logout'] = $this->lang->line('logout');
        $data['lang_point_of_sales'] = $this->lang->line('point_of_sales');
        $data['lang_amount'] = $this->lang->line('amount');
        $data['lang_monthly_sales_outlet'] = $this->lang->line('monthly_sales_outlet');
        $data['lang_no_match_found'] = $this->lang->line('no_match_found');
        $data['lang_create_return_order'] = $this->lang->line('create_return_order');

        $data['lang_action'] = $this->lang->line('action');
        $data['lang_edit'] = $this->lang->line('edit');
        $data['lang_status'] = $this->lang->line('status');
        $data['lang_add'] = $this->lang->line('add');
        $data['lang_back'] = $this->lang->line('back');
        $data['lang_update'] = $this->lang->line('update');
        $data['lang_active'] = $this->lang->line('active');
        $data['lang_inactive'] = $this->lang->line('inactive');
        $data['lang_name'] = $this->lang->line('name');

        $data['lang_suppliers'] = $this->lang->line('suppliers');
        $data['lang_telephone'] = $this->lang->line('telephone');
        $data['lang_fax'] = $this->lang->line('fax');
        $data['lang_add_supplier'] = $this->lang->line('add_supplier');
        $data['lang_delete_supplier'] = $this->lang->line('delete_supplier');
        $data['lang_supplier_tax'] = $this->lang->line('supplier_tax');
        $data['lang_name'] = $this->lang->line('name');
        $data['lang_email'] = $this->lang->line('email');

        $this->load->view('suppliers', $data);
    }

    // Add Supplier;
    public function addsupplier()
    {
        $data['lang_dashboard'] = $this->lang->line('dashboard');
        $data['lang_customers'] = $this->lang->line('customers');
        $data['lang_gift_card'] = $this->lang->line('gift_card');
        $data['lang_add_gift_card'] = $this->lang->line('add_gift_card');
        $data['lang_list_gift_card'] = $this->lang->line('list_gift_card');
        $data['lang_debit'] = $this->lang->line('debit');
        $data['lang_sales'] = $this->lang->line('sales');
        $data['lang_today_sales'] = $this->lang->line('today_sales');
        $data['lang_opened_bill'] = $this->lang->line('opened_bill');
        $data['lang_reports'] = $this->lang->line('reports');
        $data['lang_sales_report'] = $this->lang->line('sales_report');
        $data['lang_expenses'] = $this->lang->line('expenses');
        $data['lang_expenses_category'] = $this->lang->line('expenses_category');
        $data['lang_pnl'] = $this->lang->line('pnl');
        $data['lang_pnl_report'] = $this->lang->line('pnl_report');
        $data['lang_pos'] = $this->lang->line('pos');
        $data['lang_return_order'] = $this->lang->line('return_order');
        $data['lang_return_order_report'] = $this->lang->line('return_order_report');
        $data['lang_inventory'] = $this->lang->line('inventory');
        $data['lang_products'] = $this->lang->line('products');
        $data['lang_list_products'] = $this->lang->line('list_products');
        $data['lang_print_product_label'] = $this->lang->line('print_product_label');
        $data['lang_product_category'] = $this->lang->line('product_category');
        $data['lang_purchase_order'] = $this->lang->line('purchase_order');
        $data['lang_setting'] = $this->lang->line('setting');
        $data['lang_outlets'] = $this->lang->line('outlets');
        $data['lang_users'] = $this->lang->line('users');
        $data['lang_suppliers'] = $this->lang->line('suppliers');
        $data['lang_system_setting'] = $this->lang->line('system_setting');
        $data['lang_payment_methods'] = $this->lang->line('payment_methods');
        $data['lang_logout'] = $this->lang->line('logout');
        $data['lang_point_of_sales'] = $this->lang->line('point_of_sales');
        $data['lang_amount'] = $this->lang->line('amount');
        $data['lang_monthly_sales_outlet'] = $this->lang->line('monthly_sales_outlet');
        $data['lang_no_match_found'] = $this->lang->line('no_match_found');
        $data['lang_create_return_order'] = $this->lang->line('create_return_order');

        $data['lang_action'] = $this->lang->line('action');
        $data['lang_edit'] = $this->lang->line('edit');
        $data['lang_status'] = $this->lang->line('status');
        $data['lang_add'] = $this->lang->line('add');
        $data['lang_back'] = $this->lang->line('back');
        $data['lang_update'] = $this->lang->line('update');
        $data['lang_active'] = $this->lang->line('active');
        $data['lang_inactive'] = $this->lang->line('inactive');
        $data['lang_name'] = $this->lang->line('name');

        $data['lang_suppliers'] = $this->lang->line('suppliers');
        $data['lang_telephone'] = $this->lang->line('telephone');
        $data['lang_fax'] = $this->lang->line('fax');
        $data['lang_add_supplier'] = $this->lang->line('add_supplier');
        $data['lang_delete_supplier'] = $this->lang->line('delete_supplier');
        $data['lang_supplier_tax'] = $this->lang->line('supplier_tax');
        $data['lang_name'] = $this->lang->line('name');
        $data['lang_email'] = $this->lang->line('email');
        $data['lang_supplier_name'] = $this->lang->line('supplier_name');
        $data['lang_supplier_address'] = $this->lang->line('supplier_address');

        $this->load->view('add_supplier', $data);
    }

    // Edit Supplier;
    public function editsupplier()
    {
        $id = $this->input->get('id');

        $data['id'] = $id;

        $data['lang_dashboard'] = $this->lang->line('dashboard');
        $data['lang_customers'] = $this->lang->line('customers');
        $data['lang_gift_card'] = $this->lang->line('gift_card');
        $data['lang_add_gift_card'] = $this->lang->line('add_gift_card');
        $data['lang_list_gift_card'] = $this->lang->line('list_gift_card');
        $data['lang_debit'] = $this->lang->line('debit');
        $data['lang_sales'] = $this->lang->line('sales');
        $data['lang_today_sales'] = $this->lang->line('today_sales');
        $data['lang_opened_bill'] = $this->lang->line('opened_bill');
        $data['lang_reports'] = $this->lang->line('reports');
        $data['lang_sales_report'] = $this->lang->line('sales_report');
        $data['lang_expenses'] = $this->lang->line('expenses');
        $data['lang_expenses_category'] = $this->lang->line('expenses_category');
        $data['lang_pnl'] = $this->lang->line('pnl');
        $data['lang_pnl_report'] = $this->lang->line('pnl_report');
        $data['lang_pos'] = $this->lang->line('pos');
        $data['lang_return_order'] = $this->lang->line('return_order');
        $data['lang_return_order_report'] = $this->lang->line('return_order_report');
        $data['lang_inventory'] = $this->lang->line('inventory');
        $data['lang_products'] = $this->lang->line('products');
        $data['lang_list_products'] = $this->lang->line('list_products');
        $data['lang_print_product_label'] = $this->lang->line('print_product_label');
        $data['lang_product_category'] = $this->lang->line('product_category');
        $data['lang_purchase_order'] = $this->lang->line('purchase_order');
        $data['lang_setting'] = $this->lang->line('setting');
        $data['lang_outlets'] = $this->lang->line('outlets');
        $data['lang_users'] = $this->lang->line('users');
        $data['lang_suppliers'] = $this->lang->line('suppliers');
        $data['lang_system_setting'] = $this->lang->line('system_setting');
        $data['lang_payment_methods'] = $this->lang->line('payment_methods');
        $data['lang_logout'] = $this->lang->line('logout');
        $data['lang_point_of_sales'] = $this->lang->line('point_of_sales');
        $data['lang_amount'] = $this->lang->line('amount');
        $data['lang_monthly_sales_outlet'] = $this->lang->line('monthly_sales_outlet');
        $data['lang_no_match_found'] = $this->lang->line('no_match_found');
        $data['lang_create_return_order'] = $this->lang->line('create_return_order');

        $data['lang_action'] = $this->lang->line('action');
        $data['lang_edit'] = $this->lang->line('edit');
        $data['lang_status'] = $this->lang->line('status');
        $data['lang_add'] = $this->lang->line('add');
        $data['lang_back'] = $this->lang->line('back');
        $data['lang_update'] = $this->lang->line('update');
        $data['lang_active'] = $this->lang->line('active');
        $data['lang_inactive'] = $this->lang->line('inactive');
        $data['lang_name'] = $this->lang->line('name');

        $data['lang_suppliers'] = $this->lang->line('suppliers');
        $data['lang_telephone'] = $this->lang->line('telephone');
        $data['lang_fax'] = $this->lang->line('fax');
        $data['lang_add_supplier'] = $this->lang->line('add_supplier');
        $data['lang_delete_supplier'] = $this->lang->line('delete_supplier');
        $data['lang_supplier_tax'] = $this->lang->line('supplier_tax');
        $data['lang_name'] = $this->lang->line('name');
        $data['lang_email'] = $this->lang->line('email');
        $data['lang_supplier_name'] = $this->lang->line('supplier_name');
        $data['lang_supplier_address'] = $this->lang->line('supplier_address');
        $data['lang_edit_supplier'] = $this->lang->line('edit_supplier');

        $this->load->view('edit_supplier', $data);
    }

    // ****************************** View Page -- END ****************************** //

    // ****************************** Action To Database -- START ****************************** //

    // Delete Supplier;
    public function deleteSupplier()
    {
        $supplier_id = $this->input->post('supplier_id');
        $supplier_name = $this->input->post('supplier_name');

        if ($this->Constant_model->deleteData('suppliers', $supplier_id)) {
            $this->session->set_flashdata('alert_msg', array('success', 'Delete Supplier', "Successfully Deleted Supplier : $supplier_name."));
            redirect(base_url().'suppliers/suppliers');
        }
    }

    // Update Supplier;
    public function updateSupplier()
    {
        $id = $this->input->post('id');
        $name = strip_tags($this->input->post('name'));
        $email = strip_tags($this->input->post('email'));
        $tel = strip_tags($this->input->post('tel'));
        $fax = strip_tags($this->input->post('fax'));
        $address = strip_tags($this->input->post('address'));
        $status = strip_tags($this->input->post('status'));

        $tax = strip_tags($this->input->post('tax'));

        $us_id = $this->session->userdata('user_id');
        $tm = date('Y-m-d H:i:s', time());

        if (empty($name)) {
            $this->session->set_flashdata('alert_msg', array('failure', 'Update Supplier', 'Please enter Supplier Name!'));
            redirect(base_url().'suppliers/editsupplier?id='.$id);
        } elseif (empty($tel)) {
            $this->session->set_flashdata('alert_msg', array('failure', 'Update Supplier', 'Please enter Supplier Telephone Number!'));
            redirect(base_url().'suppliers/editsupplier?id='.$id);
        } elseif (empty($address)) {
            $this->session->set_flashdata('alert_msg', array('failure', 'Update Supplier', 'Please enter Supplier Address!'));
            redirect(base_url().'suppliers/editsupplier?id='.$id);
        } else {
            $upd_data = array(
                'name' => $name,
                'tax' => $tax,
                'email' => $email,
                'address' => $address,
                'tel' => $tel,
                'fax' => $fax,
                'status' => $status,
                'updated_user_id' => $us_id,
                'updated_datetime' => $tm,
            );
            if ($this->Constant_model->updateData('suppliers', $upd_data, $id)) {
                $this->session->set_flashdata('alert_msg', array('success', 'Update Supplier', "Successfully Updated Supplier : $name"));
                redirect(base_url().'suppliers/editsupplier?id='.$id);
            }
        }
    }

    // Insert New Supplier;
    public function insertSupplier()
    {
        $name = strip_tags($this->input->post('name'));
        $email = strip_tags($this->input->post('email'));
        $tel = strip_tags($this->input->post('tel'));
        $fax = strip_tags($this->input->post('fax'));
        $address = strip_tags($this->input->post('address'));
        $tax = strip_tags($this->input->post('tax'));

        $us_id = $this->session->userdata('user_id');
        $tm = date('Y-m-d H:i:s', time());

        if (empty($name)) {
            $this->session->set_flashdata('alert_msg', array('failure', 'Add Supplier', 'Please enter Supplier Name!', "$name", "$email", "$tel", "$fax", "$address", "$tax"));
            redirect(base_url().'suppliers/addsupplier');
        } elseif (empty($tel)) {
            $this->session->set_flashdata('alert_msg', array('failure', 'Add Supplier', 'Please enter Supplier Telephone Number!', "$name", "$email", "$tel", "$fax", "$address", "$tax"));
            redirect(base_url().'suppliers/addsupplier');
        } elseif (empty($address)) {
            $this->session->set_flashdata('alert_msg', array('failure', 'Add Supplier', 'Please enter Supplier Address!', "$name", "$email", "$tel", "$fax", "$address", "$tax"));
            redirect(base_url().'suppliers/addsupplier');
        } else {
            $ins_data = array(
                    'name' => $name,
                    'tax' => $tax,
                    'email' => $email,
                    'address' => $address,
                    'tel' => $tel,
                    'fax' => $fax,
                    'created_user_id' => $us_id,
                    'created_datetime' => $tm,
                    'status' => '1',
            );
            if ($this->Constant_model->insertData('suppliers', $ins_data)) {
                $this->session->set_flashdata('alert_msg', array('success', 'Add Supplier', "Successfully Added New Supplier : $name", '', '', '', '', '', ''));
                redirect(base_url().'suppliers/addsupplier');
            }
        }
    }


    // ****************************** Action To Database -- END ****************************** //

    public function editor($path, $width)
    {
        //Loading Library For Ckeditor
        $this->load->library('Ckeditor');
        $this->load->library('Ckfinder');
        //configure base path of ckeditor folder
        $this->ckeditor->basePath = base_url().'assets/ckeditor/';
        $this->ckeditor->config['toolbar'] = 'Full';
        $this->ckeditor->config['language'] = 'en';
        $this->ckeditor->config['width'] = $width;
        //configure ckfinder with ckeditor config
        $this->ckfinder->SetupCKEditor($this->ckeditor, $path);
    }
}
